<?php
require_once 'config.php';
requireLogin();

$project_id = intval($_GET['id'] ?? 0);
if ($project_id === 0) {
    header('Location: projects.php');
    exit;
}

$page_title = 'Update Project Status';

$result = $conn->query("SELECT * FROM projects WHERE id = $project_id");
if ($result->num_rows === 0) {
    setError('Project not found');
    header('Location: projects.php');
    exit;
}

$project = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = sanitize($_POST['status']);
    $depth_achieved = intval($_POST['depth_achieved'] ?? 0);
    $start_date = $_POST['start_date'] ?? null;
    $completion_date = $_POST['completion_date'] ?? null;
    $notes = sanitize($_POST['notes'] ?? '');
    
    $updates = ["status = '$new_status'"];
    
    if ($depth_achieved > 0) {
        $updates[] = "depth_achieved = $depth_achieved";
    }
    if ($start_date) {
        $updates[] = "start_date = '$start_date'";
    }
    if ($completion_date) {
        $updates[] = "completion_date = '$completion_date'";
    }
    
    $sql = "UPDATE projects SET " . implode(', ', $updates) . " WHERE id = $project_id";
    $conn->query($sql);
    
    $details = "Status updated to: " . ucwords(str_replace('_', ' ', $new_status));
    if ($depth_achieved > 0) {
        $details .= ". Depth achieved: {$depth_achieved}m";
    }
    if ($notes) {
        $details .= ". Notes: $notes";
    }
    
    logActivity($project_id, 'status_updated', $details);
    
    setSuccess("Project status updated successfully!");
    header("Location: project_details.php?id=$project_id");
    exit;
}

include 'header.php';
?>

<div style="margin-bottom: 20px;">
    <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">← Back to Project</a>
</div>

<div class="card" style="max-width: 600px;">
    <h2>Update Project Status</h2>
    <p class="text-muted">Project #<?php echo $project['project_number'] ?? $project_id; ?> - <?php echo htmlspecialchars($project['location']); ?></p>
    
    <form method="POST" action="">
        <div class="form-group">
            <label>Current Status</label>
            <input type="text" value="<?php echo ucwords(str_replace('_', ' ', $project['status'])); ?>" readonly style="background: #e9ecef;">
        </div>
        
        <div class="form-group">
            <label>New Status *</label>
            <select name="status" required>
                <option value="pending_payment" <?php echo $project['status'] === 'pending_payment' ? 'selected' : ''; ?>>Pending Payment</option>
                <option value="approved" <?php echo $project['status'] === 'approved' ? 'selected' : ''; ?>>Approved</option>
                <option value="in_progress" <?php echo $project['status'] === 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                <option value="completed" <?php echo $project['status'] === 'completed' ? 'selected' : ''; ?>>Completed</option>
                <option value="fully_paid" <?php echo $project['status'] === 'fully_paid' ? 'selected' : ''; ?>>Fully Paid</option>
                <option value="cancelled" <?php echo $project['status'] === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
            </select>
        </div>
        
        <div class="form-group">
            <label>Depth Achieved (meters)</label>
            <input type="number" name="depth_achieved" value="<?php echo $project['depth_achieved']; ?>" min="0">
            <small>Required: <?php echo $project['depth_required']; ?>m</small>
        </div>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
            <div class="form-group">
                <label>Start Date</label>
                <input type="date" name="start_date" value="<?php echo $project['start_date']; ?>">
            </div>
            
            <div class="form-group">
                <label>Completion Date</label>
                <input type="date" name="completion_date" value="<?php echo $project['completion_date']; ?>">
            </div>
        </div>
        
        <div class="form-group">
            <label>Notes</label>
            <textarea name="notes" rows="3" placeholder="Add notes about this status update..."></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary">📝 Update Status</button>
        <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php include 'footer.php'; ?>
