<?php
require_once 'config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Get form data
    $agent_id = intval($_POST['agent_id']);
    $location = sanitize($_POST['location']);
    $depth_required = intval($_POST['depth_required']);
    $rate_per_meter = floatval($_POST['rate_per_meter']);
    
    $initial_payment_percent = intval($_POST['initial_payment_percent']);
    $initial_payment_amount = floatval($_POST['initial_payment_amount']);
    $balance_amount = floatval($_POST['balance_amount']);
    $total_amount = floatval($_POST['total_amount']);
    
    $discount_amount = floatval($_POST['discount_amount'] ?? 0);
    $discount_reason = sanitize($_POST['discount_reason'] ?? '');
    $additional_charges = floatval($_POST['additional_charges'] ?? 0);
    $additional_charges_reason = sanitize($_POST['additional_charges_reason'] ?? '');
    
    $assigned_team = sanitize($_POST['assigned_team'] ?? '');
    $start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : NULL;
    $notes = sanitize($_POST['notes'] ?? '');
    
    // Generate project number
    $project_number = generateProjectNumber();
    
    // Get current user
    $created_by = $_SESSION['username'];
    
    // Prepare SQL
    $sql = "INSERT INTO projects (
        project_number, agent_id, location, depth_required, rate_per_meter,
        total_amount, initial_payment_percent, initial_payment_amount, balance_amount,
        discount_amount, discount_reason, additional_charges, additional_charges_reason,
        assigned_team, start_date, notes, created_by, status
    ) VALUES (
        ?, ?, ?, ?, ?,
        ?, ?, ?, ?,
        ?, ?, ?, ?,
        ?, ?, ?, ?, 'pending_payment'
    )";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "sisidddiiddsssss",
        $project_number, $agent_id, $location, $depth_required, $rate_per_meter,
        $total_amount, $initial_payment_percent, $initial_payment_amount, $balance_amount,
        $discount_amount, $discount_reason, $additional_charges, $additional_charges_reason,
        $assigned_team, $start_date, $notes, $created_by
    );
    
    if ($stmt->execute()) {
        $project_id = $conn->insert_id;
        
        // Log the project creation
        $details = "Project created. Total: " . formatMoney($total_amount) . 
                   ". Initial payment: {$initial_payment_percent}% (" . formatMoney($initial_payment_amount) . ")";
        logActivity($project_id, 'project_created', $details);
        
        // Update agent stats
        $conn->query("UPDATE agents SET total_jobs = total_jobs + 1 WHERE id = $agent_id");
        
        setSuccess("Project #{$project_id} created successfully! Project Number: {$project_number}");
        header("Location: project_details.php?id=" . $project_id);
        exit;
    } else {
        setError("Error creating project: " . $conn->error);
        header("Location: add_project.php");
        exit;
    }
} else {
    header("Location: add_project.php");
    exit;
}
?>
