<?php
require_once 'config.php';
requireLogin();

$page_title = 'Reports';

$month = $_GET['month'] ?? date('Y-m');

// Monthly stats
$stats = [];
$result = $conn->query("SELECT COUNT(*) as count, SUM(depth_achieved) as depth FROM projects WHERE DATE_FORMAT(completion_date, '%Y-%m') = '$month' AND status IN ('completed', 'fully_paid')");
$row = $result->fetch_assoc();
$stats['completed'] = $row['count'];
$stats['total_depth'] = $row['depth'] ?? 0;

$result = $conn->query("SELECT SUM(total_amount) as revenue FROM projects WHERE DATE_FORMAT(completion_date, '%Y-%m') = '$month' AND status IN ('completed', 'fully_paid')");
$stats['revenue'] = $result->fetch_assoc()['revenue'] ?? 0;

// Calculate costs
$diesel_cost = $stats['total_depth'] * floatval(getSetting('diesel_consumption_per_meter', 2.14)) * floatval(getSetting('diesel_price_per_liter', 990));
$maintenance = $stats['revenue'] * (floatval(getSetting('maintenance_percent', 15)) / 100);
$gm_commission = $stats['total_depth'] * floatval(getSetting('gm_commission_per_meter', 500));
$ceo_commission = $stats['total_depth'] * floatval(getSetting('ceo_commission_per_meter', 1500));
$staff_costs = $stats['completed'] * (floatval(getSetting('staff_daily_feeding', 2500)) * floatval(getSetting('staff_count', 6)));
$site_expenses = floatval(getSetting('monthly_site_expenses', 133333));

$total_costs = $diesel_cost + $maintenance + $gm_commission + $ceo_commission + $staff_costs + $site_expenses;
$net_profit = $stats['revenue'] - $total_costs;
$profit_margin = $stats['revenue'] > 0 ? ($net_profit / $stats['revenue']) * 100 : 0;

include 'header.php';
?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <div>
        <h1>Monthly Reports</h1>
        <p class="text-muted">Financial overview and performance metrics</p>
    </div>
    <form method="GET" style="display: flex; gap: 10px;">
        <input type="month" name="month" value="<?php echo $month; ?>" class="form-control">
        <button type="submit" class="btn btn-primary">View</button>
    </form>
</div>

<!-- Summary Cards -->
<div class="stats-grid">
    <div class="stat-card primary">
        <div class="stat-label">Boreholes Completed</div>
        <div class="stat-value"><?php echo $stats['completed']; ?></div>
        <div class="stat-subtext">Target: <?php echo getSetting('target_boreholes_per_month', 20); ?> per month</div>
    </div>
    
    <div class="stat-card success">
        <div class="stat-label">Total Revenue</div>
        <div class="stat-value"><?php echo formatMoney($stats['revenue']); ?></div>
        <div class="stat-subtext"><?php echo number_format($stats['total_depth']); ?>m drilled</div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-label">Total Costs</div>
        <div class="stat-value"><?php echo formatMoney($total_costs); ?></div>
    </div>
    
    <div class="stat-card <?php echo $net_profit > 0 ? 'success' : 'danger'; ?>">
        <div class="stat-label">Net Profit</div>
        <div class="stat-value"><?php echo formatMoney($net_profit); ?></div>
        <div class="stat-subtext"><?php echo number_format($profit_margin, 1); ?>% margin</div>
    </div>
</div>

<!-- Detailed Breakdown -->
<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 20px;">
    <!-- Revenue Breakdown -->
    <div class="card">
        <h3 style="margin-bottom: 20px;">Revenue Breakdown</h3>
        <table style="width: 100%;">
            <tr>
                <td>Boreholes Completed:</td>
                <td class="text-right"><strong><?php echo $stats['completed']; ?></strong></td>
            </tr>
            <tr>
                <td>Total Depth Drilled:</td>
                <td class="text-right"><strong><?php echo number_format($stats['total_depth']); ?>m</strong></td>
            </tr>
            <tr>
                <td>Average Rate:</td>
                <td class="text-right">
                    <strong><?php echo $stats['total_depth'] > 0 ? formatMoney($stats['revenue'] / $stats['total_depth']) : '₦0'; ?>/m</strong>
                </td>
            </tr>
            <tr style="border-top: 2px solid #2c3e50; font-size: 1.1rem;">
                <td><strong>Total Revenue:</strong></td>
                <td class="text-right"><strong><?php echo formatMoney($stats['revenue']); ?></strong></td>
            </tr>
        </table>
    </div>
    
    <!-- Cost Breakdown -->
    <div class="card">
        <h3 style="margin-bottom: 20px;">Cost Breakdown</h3>
        <table style="width: 100%;">
            <tr>
                <td>Diesel:</td>
                <td class="text-right"><?php echo formatMoney($diesel_cost); ?></td>
            </tr>
            <tr>
                <td>Maintenance (15%):</td>
                <td class="text-right"><?php echo formatMoney($maintenance); ?></td>
            </tr>
            <tr>
                <td>GM Commission:</td>
                <td class="text-right"><?php echo formatMoney($gm_commission); ?></td>
            </tr>
            <tr>
                <td>CEO Commission:</td>
                <td class="text-right"><?php echo formatMoney($ceo_commission); ?></td>
            </tr>
            <tr>
                <td>Staff Costs:</td>
                <td class="text-right"><?php echo formatMoney($staff_costs); ?></td>
            </tr>
            <tr>
                <td>Site Expenses:</td>
                <td class="text-right"><?php echo formatMoney($site_expenses); ?></td>
            </tr>
            <tr style="border-top: 2px solid #2c3e50; font-size: 1.1rem;">
                <td><strong>Total Costs:</strong></td>
                <td class="text-right"><strong><?php echo formatMoney($total_costs); ?></strong></td>
            </tr>
        </table>
    </div>
</div>

<!-- Projects This Month -->
<div class="card mt-20">
    <h3 style="margin-bottom: 15px;">Projects Completed This Month</h3>
    <?php
    $month_projects = $conn->query("
        SELECT p.*, a.agent_name 
        FROM projects p 
        LEFT JOIN agents a ON p.agent_id = a.id 
        WHERE DATE_FORMAT(p.completion_date, '%Y-%m') = '$month' 
        AND p.status IN ('completed', 'fully_paid')
        ORDER BY p.completion_date DESC
    ");
    ?>
    
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Project</th>
                    <th>Agent</th>
                    <th>Location</th>
                    <th>Depth</th>
                    <th>Amount</th>
                    <th>Completed</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($month_projects->num_rows > 0): ?>
                    <?php while ($project = $month_projects->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $project['project_number'] ?? '#' . $project['id']; ?></td>
                            <td><?php echo htmlspecialchars($project['agent_name']); ?></td>
                            <td><?php echo htmlspecialchars($project['location']); ?></td>
                            <td><?php echo $project['depth_achieved']; ?>m</td>
                            <td><?php echo formatMoney($project['total_amount']); ?></td>
                            <td><?php echo date('M d, Y', strtotime($project['completion_date'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted">No projects completed this month</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
