<?php
require_once 'config.php';
requireLogin();

$project_id = intval($_GET['id'] ?? 0);
$payment_type = $_GET['type'] ?? 'initial';

if ($project_id === 0) {
    header('Location: projects.php');
    exit;
}

$page_title = 'Record Payment';

// Get project details
$result = $conn->query("SELECT * FROM projects WHERE id = $project_id");
if ($result->num_rows === 0) {
    setError('Project not found');
    header('Location: projects.php');
    exit;
}

$project = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = floatval($_POST['amount']);
    $payment_method = sanitize($_POST['payment_method']);
    $payment_reference = sanitize($_POST['payment_reference'] ?? '');
    $payment_date = $_POST['payment_date'];
    $notes = sanitize($_POST['notes'] ?? '');
    $received_by = $_SESSION['username'];
    
    // Start transaction
    $conn->begin_transaction();
    
    try {
        // Insert payment record
        $stmt = $conn->prepare("INSERT INTO payments (project_id, payment_type, amount, payment_method, payment_reference, payment_date, received_by, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isdsssss", $project_id, $payment_type, $amount, $payment_method, $payment_reference, $payment_date, $received_by, $notes);
        $stmt->execute();
        
        // Update project
        if ($payment_type === 'initial') {
            $conn->query("UPDATE projects SET initial_payment_paid = 1, initial_payment_date = '$payment_date' WHERE id = $project_id");
            $conn->query("UPDATE projects SET status = 'approved' WHERE id = $project_id AND status = 'pending_payment'");
            logActivity($project_id, 'payment_received', "Initial payment of " . formatMoney($amount) . " received");
        } elseif ($payment_type === 'balance') {
            $conn->query("UPDATE projects SET balance_paid = 1, balance_payment_date = '$payment_date' WHERE id = $project_id");
            $conn->query("UPDATE projects SET status = 'fully_paid' WHERE id = $project_id");
            logActivity($project_id, 'payment_received', "Balance payment of " . formatMoney($amount) . " received");
        }
        
        $conn->commit();
        setSuccess("Payment of " . formatMoney($amount) . " recorded successfully!");
        header("Location: project_details.php?id=$project_id");
        exit;
        
    } catch (Exception $e) {
        $conn->rollback();
        setError("Error recording payment: " . $e->getMessage());
    }
}

include 'header.php';
?>

<div style="margin-bottom: 20px;">
    <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">← Back to Project</a>
</div>

<div class="card" style="max-width: 600px;">
    <h2>Record <?php echo ucfirst($payment_type); ?> Payment</h2>
    <p class="text-muted">Project #<?php echo $project['project_number'] ?? $project_id; ?> - <?php echo htmlspecialchars($project['location']); ?></p>
    
    <form method="POST" action="">
        <div class="form-group">
            <label>Payment Type</label>
            <input type="text" value="<?php echo ucfirst($payment_type); ?> Payment" readonly style="background: #e9ecef;">
        </div>
        
        <div class="form-group">
            <label>Amount (₦) *</label>
            <input type="number" name="amount" step="0.01" required 
                   value="<?php echo $payment_type === 'initial' ? $project['initial_payment_amount'] : $project['balance_amount']; ?>">
            <small>Expected: <?php echo formatMoney($payment_type === 'initial' ? $project['initial_payment_amount'] : $project['balance_amount']); ?></small>
        </div>
        
        <div class="form-group">
            <label>Payment Method *</label>
            <select name="payment_method" required>
                <option value="cash">Cash</option>
                <option value="bank_transfer" selected>Bank Transfer</option>
                <option value="pos">POS</option>
                <option value="cheque">Cheque</option>
                <option value="other">Other</option>
            </select>
        </div>
        
        <div class="form-group">
            <label>Payment Reference</label>
            <input type="text" name="payment_reference" placeholder="e.g., Transaction ID, Cheque number">
        </div>
        
        <div class="form-group">
            <label>Payment Date *</label>
            <input type="date" name="payment_date" value="<?php echo date('Y-m-d'); ?>" required>
        </div>
        
        <div class="form-group">
            <label>Notes</label>
            <textarea name="notes" rows="3" placeholder="Any additional notes..."></textarea>
        </div>
        
        <button type="submit" class="btn btn-success">💰 Record Payment</button>
        <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php include 'footer.php'; ?>
