<?php
require_once 'config.php';
requireLogin();

$page_title = 'All Projects';

// Filter options
$status_filter = $_GET['status'] ?? 'all';
$agent_filter = $_GET['agent'] ?? 'all';
$search = $_GET['search'] ?? '';

// Build query
$where = [];
if ($status_filter !== 'all') {
    $where[] = "p.status = '$status_filter'";
}
if ($agent_filter !== 'all') {
    $where[] = "p.agent_id = " . intval($agent_filter);
}
if (!empty($search)) {
    $search_safe = sanitize($search);
    $where[] = "(p.location LIKE '%$search_safe%' OR p.project_number LIKE '%$search_safe%' OR a.agent_name LIKE '%$search_safe%')";
}

$where_clause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

$projects = $conn->query("
    SELECT p.*, a.agent_name 
    FROM projects p 
    LEFT JOIN agents a ON p.agent_id = a.id 
    $where_clause
    ORDER BY p.created_at DESC
");

// Get agents for filter
$agents = $conn->query("SELECT id, agent_name FROM agents WHERE is_active = 1 ORDER BY agent_name");

include 'header.php';
?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <div>
        <h1>All Projects</h1>
        <p class="text-muted">Manage all borehole drilling projects</p>
    </div>
    <div>
        <a href="add_project.php" class="btn btn-success">+ New Project</a>
    </div>
</div>

<!-- Filters -->
<div class="card mb-20">
    <form method="GET" action="">
        <div style="display: grid; grid-template-columns: 2fr 1fr 1fr auto; gap: 15px; align-items: end;">
            <div class="form-group" style="margin: 0;">
                <label>Search</label>
                <input type="text" name="search" placeholder="Search by location, project number, or agent..." 
                       value="<?php echo htmlspecialchars($search); ?>">
            </div>
            
            <div class="form-group" style="margin: 0;">
                <label>Status</label>
                <select name="status">
                    <option value="all" <?php echo $status_filter === 'all' ? 'selected' : ''; ?>>All Statuses</option>
                    <option value="pending_payment" <?php echo $status_filter === 'pending_payment' ? 'selected' : ''; ?>>Pending Payment</option>
                    <option value="approved" <?php echo $status_filter === 'approved' ? 'selected' : ''; ?>>Approved</option>
                    <option value="in_progress" <?php echo $status_filter === 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="completed" <?php echo $status_filter === 'completed' ? 'selected' : ''; ?>>Completed</option>
                    <option value="fully_paid" <?php echo $status_filter === 'fully_paid' ? 'selected' : ''; ?>>Fully Paid</option>
                    <option value="cancelled" <?php echo $status_filter === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                </select>
            </div>
            
            <div class="form-group" style="margin: 0;">
                <label>Agent</label>
                <select name="agent">
                    <option value="all">All Agents</option>
                    <?php while ($agent = $agents->fetch_assoc()): ?>
                        <option value="<?php echo $agent['id']; ?>" <?php echo $agent_filter == $agent['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($agent['agent_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if ($status_filter !== 'all' || $agent_filter !== 'all' || !empty($search)): ?>
                    <a href="projects.php" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </div>
        </div>
    </form>
</div>

<!-- Projects Table -->
<div class="card">
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Project #</th>
                    <th>Agent</th>
                    <th>Location</th>
                    <th>Depth</th>
                    <th>Total Amount</th>
                    <th>Payment</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($projects->num_rows > 0): ?>
                    <?php while ($project = $projects->fetch_assoc()): ?>
                        <tr>
                            <td>
                                <strong><?php echo $project['project_number'] ?? '#' . $project['id']; ?></strong>
                            </td>
                            <td><?php echo htmlspecialchars($project['agent_name']); ?></td>
                            <td><?php echo htmlspecialchars($project['location']); ?></td>
                            <td>
                                <?php 
                                $depth = $project['depth_achieved'] > 0 ? $project['depth_achieved'] : $project['depth_required'];
                                echo $depth . 'm';
                                if ($project['depth_achieved'] > 0 && $project['depth_achieved'] != $project['depth_required']) {
                                    echo '<br><small class="text-muted">(Target: ' . $project['depth_required'] . 'm)</small>';
                                }
                                ?>
                            </td>
                            <td><strong><?php echo formatMoney($project['total_amount']); ?></strong></td>
                            <td>
                                <div style="font-size: 0.85rem;">
                                    <?php if ($project['initial_payment_paid']): ?>
                                        <span class="badge badge-completed">✓ Initial: <?php echo formatMoney($project['initial_payment_amount']); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-pending">Pending: <?php echo formatMoney($project['initial_payment_amount']); ?></span>
                                    <?php endif; ?>
                                    
                                    <br>
                                    
                                    <?php if ($project['balance_amount'] > 0): ?>
                                        <?php if ($project['balance_paid']): ?>
                                            <span class="badge badge-completed">✓ Balance: <?php echo formatMoney($project['balance_amount']); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-warning">Due: <?php echo formatMoney($project['balance_amount']); ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php
                                $status_class = [
                                    'pending_payment' => 'pending',
                                    'approved' => 'approved',
                                    'in_progress' => 'progress',
                                    'completed' => 'completed',
                                    'fully_paid' => 'paid',
                                    'cancelled' => 'cancelled'
                                ];
                                $class = $status_class[$project['status']] ?? 'pending';
                                $status_text = ucwords(str_replace('_', ' ', $project['status']));
                                ?>
                                <span class="badge badge-<?php echo $class; ?>"><?php echo $status_text; ?></span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    <?php echo date('M d, Y', strtotime($project['created_at'])); ?>
                                </small>
                            </td>
                            <td>
                                <a href="project_details.php?id=<?php echo $project['id']; ?>" 
                                   class="btn btn-primary btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted" style="padding: 40px;">
                            No projects found. 
                            <?php if ($status_filter !== 'all' || $agent_filter !== 'all' || !empty($search)): ?>
                                <a href="projects.php">Clear filters</a> or 
                            <?php endif; ?>
                            <a href="add_project.php">create your first project</a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($projects->num_rows > 0): ?>
        <div style="padding: 15px; border-top: 1px solid #e9ecef; color: #6c757d;">
            Showing <?php echo $projects->num_rows; ?> project(s)
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
