<?php
require_once 'config.php';
requireLogin();

$project_id = intval($_GET['id'] ?? 0);
if ($project_id === 0) {
    header('Location: projects.php');
    exit;
}

$page_title = 'Project Details';

// Get project details
$result = $conn->query("
    SELECT p.*, a.agent_name, a.phone as agent_phone, a.whatsapp as agent_whatsapp
    FROM projects p
    LEFT JOIN agents a ON p.agent_id = a.id
    WHERE p.id = $project_id
");

if ($result->num_rows === 0) {
    setError('Project not found');
    header('Location: projects.php');
    exit;
}

$project = $result->fetch_assoc();

// Get payment history
$payments = $conn->query("SELECT * FROM payments WHERE project_id = $project_id ORDER BY payment_date DESC");

// Get activity logs
$activities = $conn->query("SELECT * FROM activity_logs WHERE project_id = $project_id ORDER BY created_at DESC LIMIT 10");

include 'header.php';

$status_class = [
    'pending_payment' => 'pending',
    'approved' => 'approved',
    'in_progress' => 'progress',
    'completed' => 'completed',
    'fully_paid' => 'paid',
    'cancelled' => 'cancelled'
];
$class = $status_class[$project['status']] ?? 'pending';
$status_text = ucwords(str_replace('_', ' ', $project['status']));
?>

<div style="margin-bottom: 20px;">
    <a href="projects.php" class="btn btn-secondary">← Back to Projects</a>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px;">
    <!-- Main Details -->
    <div>
        <div class="card">
            <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 20px;">
                <div>
                    <h2 style="margin-bottom: 5px;">Project <?php echo $project['project_number'] ?? '#' . $project['id']; ?></h2>
                    <p class="text-muted"><?php echo htmlspecialchars($project['location']); ?></p>
                </div>
                <span class="badge badge-<?php echo $class; ?>" style="font-size: 1rem; padding: 8px 16px;">
                    <?php echo $status_text; ?>
                </span>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; padding: 20px; background: #f8f9fa; border-radius: 4px; margin-bottom: 20px;">
                <div>
                    <strong>Agent:</strong><br>
                    <?php echo htmlspecialchars($project['agent_name']); ?><br>
                    <small class="text-muted">📞 <?php echo $project['agent_phone']; ?></small>
                </div>
                <div>
                    <strong>Team:</strong><br>
                    <?php echo $project['assigned_team'] ?: 'Not assigned'; ?>
                </div>
                <div>
                    <strong>Depth Required:</strong><br>
                    <?php echo $project['depth_required']; ?> meters
                </div>
                <div>
                    <strong>Depth Achieved:</strong><br>
                    <?php echo $project['depth_achieved'] > 0 ? $project['depth_achieved'] . ' meters' : 'Pending'; ?>
                </div>
                <div>
                    <strong>Start Date:</strong><br>
                    <?php echo $project['start_date'] ? date('M d, Y', strtotime($project['start_date'])) : 'Not started'; ?>
                </div>
                <div>
                    <strong>Completion Date:</strong><br>
                    <?php echo $project['completion_date'] ? date('M d, Y', strtotime($project['completion_date'])) : 'Ongoing'; ?>
                </div>
            </div>
            
            <?php if ($project['notes']): ?>
            <div style="padding: 15px; background: #fff3cd; border-left: 4px solid #ffc107; border-radius: 4px; margin-bottom: 20px;">
                <strong>Notes:</strong><br>
                <?php echo nl2br(htmlspecialchars($project['notes'])); ?>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Financial Summary -->
        <div class="card">
            <h3 style="margin-bottom: 20px;">Financial Summary</h3>
            
            <table style="width: 100%;">
                <tr>
                    <td><strong>Base Amount:</strong></td>
                    <td class="text-right">
                        <?php echo formatMoney($project['depth_required'] * $project['rate_per_meter']); ?>
                        <small class="text-muted">(<?php echo $project['depth_required']; ?>m × <?php echo formatMoney($project['rate_per_meter']); ?>/m)</small>
                    </td>
                </tr>
                <?php if ($project['discount_amount'] > 0): ?>
                <tr style="color: #27ae60;">
                    <td><strong>Discount:</strong> <small><?php echo htmlspecialchars($project['discount_reason']); ?></small></td>
                    <td class="text-right">- <?php echo formatMoney($project['discount_amount']); ?></td>
                </tr>
                <?php endif; ?>
                <?php if ($project['additional_charges'] > 0): ?>
                <tr style="color: #e74c3c;">
                    <td><strong>Additional Charges:</strong> <small><?php echo htmlspecialchars($project['additional_charges_reason']); ?></small></td>
                    <td class="text-right">+ <?php echo formatMoney($project['additional_charges']); ?></td>
                </tr>
                <?php endif; ?>
                <tr style="border-top: 2px solid #2c3e50; font-size: 1.1rem;">
                    <td><strong>Total Project Amount:</strong></td>
                    <td class="text-right"><strong><?php echo formatMoney($project['total_amount']); ?></strong></td>
                </tr>
            </table>
            
            <div style="margin-top: 30px;">
                <h4 style="margin-bottom: 15px;">Payment Breakdown</h4>
                
                <div style="background: #e8f5e9; padding: 15px; border-radius: 4px; margin-bottom: 10px;">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div>
                            <strong>Initial Payment (<?php echo $project['initial_payment_percent']; ?>%)</strong>
                            <?php if ($project['initial_payment_paid']): ?>
                                <span class="badge badge-completed" style="margin-left: 10px;">✓ PAID</span>
                            <?php else: ?>
                                <span class="badge badge-pending" style="margin-left: 10px;">PENDING</span>
                            <?php endif; ?>
                            <?php if ($project['initial_payment_date']): ?>
                                <br><small class="text-muted">Paid on: <?php echo date('M d, Y', strtotime($project['initial_payment_date'])); ?></small>
                            <?php endif; ?>
                        </div>
                        <div style="font-size: 1.2rem; font-weight: bold; color: #2e7d32;">
                            <?php echo formatMoney($project['initial_payment_amount']); ?>
                        </div>
                    </div>
                </div>
                
                <?php if ($project['balance_amount'] > 0): ?>
                <div style="background: #fff3e0; padding: 15px; border-radius: 4px;">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div>
                            <strong>Balance Payment (<?php echo 100 - $project['initial_payment_percent']; ?>%)</strong>
                            <?php if ($project['balance_paid']): ?>
                                <span class="badge badge-completed" style="margin-left: 10px;">✓ PAID</span>
                            <?php else: ?>
                                <span class="badge badge-warning" style="margin-left: 10px;">DUE</span>
                            <?php endif; ?>
                            <?php if ($project['balance_payment_date']): ?>
                                <br><small class="text-muted">Paid on: <?php echo date('M d, Y', strtotime($project['balance_payment_date'])); ?></small>
                            <?php endif; ?>
                        </div>
                        <div style="font-size: 1.2rem; font-weight: bold; color: #f57c00;">
                            <?php echo formatMoney($project['balance_amount']); ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Payment History -->
        <?php if ($payments->num_rows > 0): ?>
        <div class="card">
            <h3 style="margin-bottom: 20px;">Payment History</h3>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Reference</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($payment = $payments->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo date('M d, Y', strtotime($payment['payment_date'])); ?></td>
                        <td><?php echo ucfirst($payment['payment_type']); ?></td>
                        <td><strong><?php echo formatMoney($payment['amount']); ?></strong></td>
                        <td><?php echo ucwords(str_replace('_', ' ', $payment['payment_method'])); ?></td>
                        <td><?php echo $payment['payment_reference'] ?: '-'; ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Actions & Status -->
    <div>
        <div class="card">
            <h3 style="margin-bottom: 20px;">Quick Actions</h3>
            
            <?php if (!$project['initial_payment_paid']): ?>
            <a href="record_payment.php?id=<?php echo $project_id; ?>&type=initial" 
               class="btn btn-success" style="width: 100%; margin-bottom: 10px;">
                💰 Record Initial Payment
            </a>
            <?php endif; ?>
            
            <?php if ($project['initial_payment_paid'] && !$project['balance_paid'] && $project['balance_amount'] > 0): ?>
            <a href="record_payment.php?id=<?php echo $project_id; ?>&type=balance" 
               class="btn btn-success" style="width: 100%; margin-bottom: 10px;">
                💰 Record Balance Payment
            </a>
            <?php endif; ?>
            
            <a href="update_status.php?id=<?php echo $project_id; ?>" 
               class="btn btn-primary" style="width: 100%; margin-bottom: 10px;">
                📝 Update Status
            </a>
            
            <a href="edit_project.php?id=<?php echo $project_id; ?>" 
               class="btn btn-warning" style="width: 100%; margin-bottom: 10px;">
                ✏️ Edit Project
            </a>
            
            <?php if ($project['agent_whatsapp']): ?>
            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $project['agent_whatsapp']); ?>" 
               target="_blank" class="btn btn-success" style="width: 100%; margin-bottom: 10px;">
                📱 WhatsApp Agent
            </a>
            <?php endif; ?>
        </div>
        
        <!-- Activity Log -->
        <?php if ($activities->num_rows > 0): ?>
        <div class="card">
            <h3 style="margin-bottom: 15px;">Activity Log</h3>
            <div style="max-height: 400px; overflow-y: auto;">
                <?php while ($activity = $activities->fetch_assoc()): ?>
                <div style="padding: 10px; border-left: 3px solid #3498db; margin-bottom: 10px; background: #f8f9fa;">
                    <div style="font-size: 0.85rem; color: #7f8c8d;">
                        <?php echo date('M d, Y H:i', strtotime($activity['created_at'])); ?>
                        <?php if ($activity['user']): ?>
                            · by <?php echo htmlspecialchars($activity['user']); ?>
                        <?php endif; ?>
                    </div>
                    <div style="margin-top: 5px;">
                        <strong><?php echo ucwords(str_replace('_', ' ', $activity['action'])); ?></strong>
                        <?php if ($activity['details']): ?>
                            <br><small><?php echo htmlspecialchars($activity['details']); ?></small>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'footer.php'; ?>
