<?php
require_once 'config.php';
requireLogin();

$page_title = 'Payments';

// Get all payments
$payments = $conn->query("
    SELECT pay.*, p.project_number, p.location, a.agent_name
    FROM payments pay
    LEFT JOIN projects p ON pay.project_id = p.id
    LEFT JOIN agents a ON p.agent_id = a.id
    ORDER BY pay.payment_date DESC
    LIMIT 100
");

// Get outstanding balances
$outstanding = $conn->query("
    SELECT p.*, a.agent_name
    FROM projects p
    LEFT JOIN agents a ON p.agent_id = a.id
    WHERE p.balance_paid = 0 AND p.balance_amount > 0 AND p.status IN ('completed', 'fully_paid')
    ORDER BY p.completion_date ASC
");

include 'header.php';
?>

<h1>Payments</h1>

<!-- Summary Cards -->
<div class="stats-grid" style="margin-bottom: 30px;">
    <?php
    $today_payments = $conn->query("SELECT SUM(amount) as total FROM payments WHERE payment_date = CURDATE()")->fetch_assoc()['total'] ?? 0;
    $month_payments = $conn->query("SELECT SUM(amount) as total FROM payments WHERE MONTH(payment_date) = MONTH(CURDATE())")->fetch_assoc()['total'] ?? 0;
    $outstanding_total = $conn->query("SELECT SUM(balance_amount) as total FROM projects WHERE balance_paid = 0")->fetch_assoc()['total'] ?? 0;
    ?>
    
    <div class="stat-card success">
        <div class="stat-label">Today's Collections</div>
        <div class="stat-value"><?php echo formatMoney($today_payments); ?></div>
    </div>
    
    <div class="stat-card primary">
        <div class="stat-label">This Month's Collections</div>
        <div class="stat-value"><?php echo formatMoney($month_payments); ?></div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-label">Total Outstanding</div>
        <div class="stat-value"><?php echo formatMoney($outstanding_total); ?></div>
    </div>
</div>

<!-- Outstanding Balances -->
<?php if ($outstanding->num_rows > 0): ?>
<div class="card mb-20">
    <h3 style="margin-bottom: 15px;">⚠️ Outstanding Balances</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Project</th>
                    <th>Agent</th>
                    <th>Location</th>
                    <th>Completed</th>
                    <th>Balance Due</th>
                    <th>Days Overdue</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($project = $outstanding->fetch_assoc()): ?>
                    <?php 
                    $days_overdue = $project['completion_date'] ? 
                        (strtotime('now') - strtotime($project['completion_date'])) / 86400 : 0;
                    ?>
                    <tr>
                        <td><strong><?php echo $project['project_number'] ?? '#' . $project['id']; ?></strong></td>
                        <td><?php echo htmlspecialchars($project['agent_name']); ?></td>
                        <td><?php echo htmlspecialchars($project['location']); ?></td>
                        <td><?php echo $project['completion_date'] ? date('M d, Y', strtotime($project['completion_date'])) : '-'; ?></td>
                        <td class="text-danger"><strong><?php echo formatMoney($project['balance_amount']); ?></strong></td>
                        <td>
                            <?php if ($days_overdue > 0): ?>
                                <span class="badge badge-<?php echo $days_overdue > 7 ? 'danger' : 'warning'; ?>">
                                    <?php echo floor($days_overdue); ?> days
                                </span>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="record_payment.php?id=<?php echo $project['id']; ?>&type=balance" 
                               class="btn btn-success btn-sm">Record Payment</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<!-- Recent Payments -->
<div class="card">
    <h3 style="margin-bottom: 15px;">Recent Payments</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Project</th>
                    <th>Agent</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Reference</th>
                    <th>Received By</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($payments->num_rows > 0): ?>
                    <?php while ($payment = $payments->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo date('M d, Y', strtotime($payment['payment_date'])); ?></td>
                            <td>
                                <a href="project_details.php?id=<?php echo $payment['project_id']; ?>">
                                    <?php echo $payment['project_number'] ?? '#' . $payment['project_id']; ?>
                                </a>
                            </td>
                            <td><?php echo htmlspecialchars($payment['agent_name']); ?></td>
                            <td><span class="badge badge-primary"><?php echo ucfirst($payment['payment_type']); ?></span></td>
                            <td><strong><?php echo formatMoney($payment['amount']); ?></strong></td>
                            <td><?php echo ucwords(str_replace('_', ' ', $payment['payment_method'])); ?></td>
                            <td><?php echo $payment['payment_reference'] ?: '-'; ?></td>
                            <td><small class="text-muted"><?php echo $payment['received_by']; ?></small></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted">No payments recorded yet</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
