<?php
require_once 'config.php';
requireLogin();

$page_title = 'Dashboard';

// Get current month stats
$current_month = date('Y-m');
$stats = [];

// Total projects this month
$result = $conn->query("SELECT COUNT(*) as count FROM projects WHERE DATE_FORMAT(created_at, '%Y-%m') = '$current_month'");
$stats['projects_this_month'] = $result->fetch_assoc()['count'];

// Completed boreholes this month
$result = $conn->query("SELECT COUNT(*) as count, SUM(depth_achieved) as total_depth FROM projects WHERE status = 'completed' OR status = 'fully_paid' AND DATE_FORMAT(completion_date, '%Y-%m') = '$current_month'");
$row = $result->fetch_assoc();
$stats['completed_this_month'] = $row['count'];
$stats['total_depth_this_month'] = $row['total_depth'] ?? 0;

// Revenue this month
$result = $conn->query("SELECT SUM(total_amount) as revenue FROM projects WHERE (status = 'completed' OR status = 'fully_paid') AND DATE_FORMAT(completion_date, '%Y-%m') = '$current_month'");
$stats['revenue_this_month'] = $result->fetch_assoc()['revenue'] ?? 0;

// Outstanding balances
$result = $conn->query("SELECT SUM(balance_amount) as total FROM projects WHERE balance_paid = 0 AND status IN ('completed', 'fully_paid')");
$stats['outstanding_balance'] = $result->fetch_assoc()['total'] ?? 0;

// Active projects
$result = $conn->query("SELECT COUNT(*) as count FROM projects WHERE status IN ('approved', 'in_progress')");
$stats['active_projects'] = $result->fetch_assoc()['count'];

// Pending payments (waiting for initial deposit)
$result = $conn->query("SELECT COUNT(*) as count FROM projects WHERE status = 'pending_payment'");
$stats['pending_payments'] = $result->fetch_assoc()['count'];

// Target progress
$target = intval(getSetting('target_boreholes_per_month', 20));
$progress_percent = $target > 0 ? round(($stats['completed_this_month'] / $target) * 100) : 0;

// Recent projects
$recent_projects = $conn->query("
    SELECT p.*, a.agent_name 
    FROM projects p 
    LEFT JOIN agents a ON p.agent_id = a.id 
    ORDER BY p.created_at DESC 
    LIMIT 10
");

// Today's activity
$today = date('Y-m-d');
$today_completed = $conn->query("SELECT COUNT(*) as count FROM projects WHERE completion_date = '$today'")->fetch_assoc()['count'];
$today_started = $conn->query("SELECT COUNT(*) as count FROM projects WHERE start_date = '$today'")->fetch_assoc()['count'];

include 'header.php';
?>

<h1>Dashboard</h1>
<p class="text-muted">Welcome back, <?php echo $_SESSION['full_name']; ?>! Here's your overview for <?php echo date('F Y'); ?>.</p>

<!-- Stats Cards -->
<div class="stats-grid" style="margin-top: 20px;">
    <div class="stat-card primary">
        <div class="stat-label">This Month's Projects</div>
        <div class="stat-value"><?php echo $stats['projects_this_month']; ?></div>
        <div class="stat-subtext">Total projects created</div>
    </div>
    
    <div class="stat-card success">
        <div class="stat-label">Completed Boreholes</div>
        <div class="stat-value"><?php echo $stats['completed_this_month']; ?> / <?php echo $target; ?></div>
        <div class="stat-subtext">
            <?php echo $progress_percent; ?>% of monthly target
            <?php if ($stats['total_depth_this_month'] > 0): ?>
                | <?php echo number_format($stats['total_depth_this_month']); ?>m drilled
            <?php endif; ?>
        </div>
    </div>
    
    <div class="stat-card success">
        <div class="stat-label">Revenue This Month</div>
        <div class="stat-value"><?php echo formatMoney($stats['revenue_this_month']); ?></div>
        <div class="stat-subtext">From completed projects</div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-label">Outstanding Balances</div>
        <div class="stat-value"><?php echo formatMoney($stats['outstanding_balance']); ?></div>
        <div class="stat-subtext">Pending collection</div>
    </div>
</div>

<!-- Quick Stats Row -->
<div class="stats-grid">
    <div class="stat-card primary">
        <div class="stat-label">Active Projects</div>
        <div class="stat-value"><?php echo $stats['active_projects']; ?></div>
        <div class="stat-subtext">In progress or approved</div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-label">Pending Initial Payment</div>
        <div class="stat-value"><?php echo $stats['pending_payments']; ?></div>
        <div class="stat-subtext">Waiting for deposit</div>
    </div>
    
    <div class="stat-card primary">
        <div class="stat-label">Today's Activity</div>
        <div class="stat-value"><?php echo $today_started; ?> / <?php echo $today_completed; ?></div>
        <div class="stat-subtext">Started / Completed</div>
    </div>
    
    <div class="stat-card success">
        <div class="stat-label">Quick Actions</div>
        <div style="margin-top: 10px;">
            <a href="add_project.php" class="btn btn-primary btn-sm">New Project</a>
            <a href="payments.php" class="btn btn-success btn-sm">Record Payment</a>
        </div>
    </div>
</div>

<!-- Recent Projects -->
<div class="card">
    <div class="card-header">Recent Projects</div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Agent</th>
                    <th>Location</th>
                    <th>Depth</th>
                    <th>Amount</th>
                    <th>Payment Status</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($recent_projects->num_rows > 0): ?>
                    <?php while ($project = $recent_projects->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo $project['id']; ?></td>
                            <td><?php echo htmlspecialchars($project['agent_name']); ?></td>
                            <td><?php echo htmlspecialchars($project['location']); ?></td>
                            <td><?php echo $project['depth_achieved'] > 0 ? $project['depth_achieved'] : $project['depth_required']; ?>m</td>
                            <td><?php echo formatMoney($project['total_amount']); ?></td>
                            <td>
                                <?php if ($project['initial_payment_paid']): ?>
                                    <span class="badge badge-completed">✓ Initial</span>
                                <?php else: ?>
                                    <span class="badge badge-pending">Pending</span>
                                <?php endif; ?>
                                
                                <?php if ($project['balance_paid']): ?>
                                    <span class="badge badge-completed">✓ Balance</span>
                                <?php elseif ($project['status'] == 'completed'): ?>
                                    <span class="badge badge-warning">Balance Due</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                $status_class = [
                                    'pending_payment' => 'pending',
                                    'approved' => 'approved',
                                    'in_progress' => 'progress',
                                    'completed' => 'completed',
                                    'fully_paid' => 'paid',
                                    'cancelled' => 'cancelled'
                                ];
                                $class = $status_class[$project['status']] ?? 'pending';
                                $status_text = ucwords(str_replace('_', ' ', $project['status']));
                                ?>
                                <span class="badge badge-<?php echo $class; ?>"><?php echo $status_text; ?></span>
                            </td>
                            <td>
                                <a href="project_details.php?id=<?php echo $project['id']; ?>" class="btn btn-primary btn-sm">View</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted">No projects yet. <a href="add_project.php">Create your first project</a></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($recent_projects->num_rows > 0): ?>
        <div style="text-align: right; margin-top: 15px;">
            <a href="projects.php" class="btn btn-secondary">View All Projects</a>
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
