<?php
require_once 'config.php';
requireLogin();

$project_id = intval($_GET['id'] ?? 0);
if ($project_id === 0) {
    header('Location: projects.php');
    exit;
}

$page_title = 'Edit Project';

$result = $conn->query("SELECT * FROM projects WHERE id = $project_id");
if ($result->num_rows === 0) {
    setError('Project not found');
    header('Location: projects.php');
    exit;
}

$project = $result->fetch_assoc();
$agents = $conn->query("SELECT * FROM agents WHERE is_active = 1 ORDER BY agent_name");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $agent_id = intval($_POST['agent_id']);
    $location = sanitize($_POST['location']);
    $depth_required = intval($_POST['depth_required']);
    $assigned_team = sanitize($_POST['assigned_team']);
    $notes = sanitize($_POST['notes']);
    
    $conn->query("UPDATE projects SET 
        agent_id = $agent_id,
        location = '$location',
        depth_required = $depth_required,
        assigned_team = '$assigned_team',
        notes = '$notes'
        WHERE id = $project_id
    ");
    
    logActivity($project_id, 'project_updated', 'Project details updated');
    setSuccess("Project updated successfully!");
    header("Location: project_details.php?id=$project_id");
    exit;
}

include 'header.php';
?>

<div style="margin-bottom: 20px;">
    <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">← Back to Project</a>
</div>

<div class="card" style="max-width: 800px;">
    <h2>Edit Project</h2>
    <p class="text-muted">Project #<?php echo $project['project_number'] ?? $project_id; ?></p>
    
    <form method="POST" action="">
        <div class="form-group">
            <label>Agent *</label>
            <select name="agent_id" required>
                <?php while ($agent = $agents->fetch_assoc()): ?>
                    <option value="<?php echo $agent['id']; ?>" <?php echo $agent['id'] == $project['agent_id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($agent['agent_name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        
        <div class="form-group">
            <label>Location *</label>
            <input type="text" name="location" value="<?php echo htmlspecialchars($project['location']); ?>" required>
        </div>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
            <div class="form-group">
                <label>Depth Required (meters) *</label>
                <input type="number" name="depth_required" value="<?php echo $project['depth_required']; ?>" required>
            </div>
            
            <div class="form-group">
                <label>Assigned Team</label>
                <select name="assigned_team">
                    <option value="">Not assigned</option>
                    <option value="Team A" <?php echo $project['assigned_team'] === 'Team A' ? 'selected' : ''; ?>>Team A</option>
                    <option value="Team B" <?php echo $project['assigned_team'] === 'Team B' ? 'selected' : ''; ?>>Team B</option>
                    <option value="Team C" <?php echo $project['assigned_team'] === 'Team C' ? 'selected' : ''; ?>>Team C</option>
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label>Notes</label>
            <textarea name="notes" rows="4"><?php echo htmlspecialchars($project['notes']); ?></textarea>
        </div>
        
        <div style="background: #fff3cd; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
            <strong>⚠️ Note:</strong> To change payment amounts or financial details, please contact the administrator.
        </div>
        
        <button type="submit" class="btn btn-success">💾 Save Changes</button>
        <a href="project_details.php?id=<?php echo $project_id; ?>" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php include 'footer.php'; ?>
