<?php
// ============================================
// Database Configuration
// ============================================
// EDIT THESE VALUES WITH YOUR DATABASE DETAILS
// ============================================

define('DB_HOST', 'localhost');        // Usually 'localhost'
define('DB_USERNAME', 'your_username'); // Your database username
define('DB_PASSWORD', 'your_password'); // Your database password
define('DB_NAME', 'borehole_tech');    // Your database name

// ============================================
// Application Settings
// ============================================
define('SITE_URL', 'http://localhost/borehole_system'); // Your site URL
define('SITE_NAME', 'Sub2me Borehole Tech');
define('TIMEZONE', 'Africa/Lagos');

// Set timezone
date_default_timezone_set(TIMEZONE);

// ============================================
// Database Connection
// ============================================
$conn = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Database Connection Failed: " . $conn->connect_error);
}

// Set charset to utf8mb4
$conn->set_charset("utf8mb4");

// ============================================
// Session Configuration
// ============================================
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ============================================
// Helper Functions
// ============================================

// Format currency
function formatMoney($amount) {
    return '₦' . number_format($amount, 2);
}

// Format number
function formatNumber($number) {
    return number_format($number);
}

// Get current user
function getCurrentUser() {
    return $_SESSION['user'] ?? null;
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Require login
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Check user role
function hasRole($role) {
    if (!isLoggedIn()) return false;
    return $_SESSION['user_role'] === $role || $_SESSION['user_role'] === 'admin';
}

// Sanitize input
function sanitize($data) {
    global $conn;
    return $conn->real_escape_string(trim($data));
}

// Get setting value
function getSetting($key, $default = '') {
    global $conn;
    $key = sanitize($key);
    $result = $conn->query("SELECT setting_value FROM settings WHERE setting_key = '$key'");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['setting_value'];
    }
    return $default;
}

// Update setting
function updateSetting($key, $value) {
    global $conn;
    $key = sanitize($key);
    $value = sanitize($value);
    $conn->query("UPDATE settings SET setting_value = '$value' WHERE setting_key = '$key'");
}

// Log activity
function logActivity($project_id, $action, $details) {
    global $conn;
    $user = $_SESSION['username'] ?? 'System';
    $stmt = $conn->prepare("INSERT INTO activity_logs (project_id, action, details, user) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $project_id, $action, $details, $user);
    $stmt->execute();
}

// Generate project number
function generateProjectNumber() {
    global $conn;
    $year = date('Y');
    $result = $conn->query("SELECT COUNT(*) as count FROM projects WHERE YEAR(created_at) = $year");
    $row = $result->fetch_assoc();
    $number = $row['count'] + 1;
    return 'BH-' . $year . '-' . str_pad($number, 4, '0', STR_PAD_LEFT);
}

// Calculate project costs
function calculateProjectCosts($depth, $days_on_site = 1) {
    $diesel_per_liter = floatval(getSetting('diesel_price_per_liter', 990));
    $diesel_per_meter = floatval(getSetting('diesel_consumption_per_meter', 2.14));
    $gm_per_meter = floatval(getSetting('gm_commission_per_meter', 500));
    $ceo_per_meter = floatval(getSetting('ceo_commission_per_meter', 1500));
    $staff_feeding = floatval(getSetting('staff_daily_feeding', 2500));
    $staff_count = intval(getSetting('staff_count', 6));
    
    $diesel_cost = $depth * $diesel_per_meter * $diesel_per_liter;
    $gm_commission = $depth * $gm_per_meter;
    $ceo_commission = $depth * $ceo_per_meter;
    $feeding_cost = $staff_feeding * $staff_count * $days_on_site;
    
    return [
        'diesel' => $diesel_cost,
        'gm_commission' => $gm_commission,
        'ceo_commission' => $ceo_commission,
        'feeding' => $feeding_cost,
        'total' => $diesel_cost + $gm_commission + $ceo_commission + $feeding_cost
    ];
}

// Success message
function setSuccess($message) {
    $_SESSION['success_message'] = $message;
}

// Error message
function setError($message) {
    $_SESSION['error_message'] = $message;
}

// Get and clear success message
function getSuccess() {
    if (isset($_SESSION['success_message'])) {
        $message = $_SESSION['success_message'];
        unset($_SESSION['success_message']);
        return $message;
    }
    return null;
}

// Get and clear error message
function getError() {
    if (isset($_SESSION['error_message'])) {
        $message = $_SESSION['error_message'];
        unset($_SESSION['error_message']);
        return $message;
    }
    return null;
}

?>
